
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Vector;

// Referenced classes of package duggelz.jape:
//            InsetPanel, ChoiceView, DataChangeEvent, DataChangeListener,
//            DataChangeMixin, FieldView, NumberView, Skill,
//            Structure, TextView, Actor, Mercenary

public class StatPanel extends InsetPanel
    implements DataChangeListener
{

    public StatPanel(Frame parent)
    {
        super(new Insets(10, 10, 10, 10));
        layout = new GridBagLayout();
        constraint = new GridBagConstraints();
        modified = false;
        views = new Vector();
        mixin = new DataChangeMixin();
        this.parent = parent;
        setLayout(layout);
        constraint.anchor = 16;
        constraint.fill = 0;
        constraint.gridx = 0;
        constraint.gridheight = 1;
        constraint.gridwidth = 1;
        constraint.insets = new Insets(0, 0, 0, 0);
        addStringStat("Name", "Name", 30);
        addStringStat("Nickname", "Nickname", 30);
        newRow();
        addText(1, "Gesundheit", 0);
        addNumberView(1, "Health", 3);
        addText(1, "/", 1);
        addNumberView(1, "Max Health", 3);
        addText(1, "(+", 2);
        addNumberView(1, "Health Inc", 3);
        addText(1, ")", 0);
        addByteStat("Energie", "Energy");
        addByteStat("Moral", "Morale");
        addIncStat("Beweglichkeit", "Agility", "Agility Inc");
        addIncStat("Geschicklichkeit", "Dexterity", "Dexterity Inc");
        addIncStat("Kraft", "Strength", "Strength Inc");
        addIncStat("Fhrungsqualitt", "Leadership", "Leadership Inc");
        addIncStat("Weisheit", "Wisdom", "Wisdom Inc");
        addIncStat("Treffsicherheit", "Marksmanship", "Marksmanship Inc");
        addIncStat("Sprengstoffe", "Explosives", "Explosives Inc");
        addIncStat("Mechanik", "Mechanical", "Mechanical Inc");
        addIncStat("Medizin", "Medical", "Medical Inc");
        addIncStat("Erfahrungslevel", "Level", "Level Inc");
        addChoiceStat("Fhigkeit 1", "Skill1", Skill.list);
        addChoiceStat("Fhigkeit 2", "Skill2", Skill.list);
        addShortStat("Ttete", "Kills");
        addShortStat("Half bei", "Assists");
        addShortStat("Feuerte Schsse ab", "Shots Fired");
        addShortStat("Schsse getroffen", "Shots Hit");
        addShortStat("Einstze", "Battles");
        addShortStat("Verwundet", "Wounds");
        newRow();
        constraint.fill = 1;
        constraint.weightx = 1.0D;
        constraint.weighty = 1.0D;
        addComponent(0, new Label());
    }

    public void addByteStat(String statTitle, String statField)
    {
        newRow();
        addText(1, statTitle, 0);
        addNumberView(1, statField, 3);
    }

    public void addChoiceStat(String statTitle, String statField, Vector statChoices)
    {
        newRow();
        addText(1, statTitle, 0);
        ChoiceView view = new ChoiceView(statField, statChoices);
        addComponent(0, view);
        views.addElement(view);
        view.addDataChangeListener(this);
    }

    private void addComponent(int colwidth, Component component)
    {
        constraint.gridwidth = colwidth;
        add(component, constraint);
        constraint.gridx += colwidth;
    }

    public void addDataChangeListener(DataChangeListener l)
    {
        mixin.addDataChangeListener(l);
    }

    public void addIncStat(String statTitle, String statField, String incStatField)
    {
        newRow();
        addText(1, statTitle, 0);
        addNumberView(1, statField, 3);
        addText(1, "(+", 2);
        addNumberView(1, incStatField, 3);
        addText(1, ")", 0);
    }

    private void addNumberView(int colwidth, String statField, int charWidth)
    {
        NumberView view = new NumberView(statField, charWidth);
        addComponent(colwidth, view);
        views.addElement(view);
        view.addDataChangeListener(this);
    }

    public void addShortStat(String statTitle, String statField)
    {
        addByteStat(statTitle, statField);
    }

    public void addStringStat(String statTitle, String statField, int charWidth)
    {
        newRow();
        addText(1, statTitle, 0);
        addNumberView(0, statField, charWidth);
    }

    private void addText(int colwidth, String text, int align)
    {
        Label label = new Label(text, align);
        addComponent(colwidth, label);
    }

    private void addTextView(int colwidth, String statField, int charWidth)
    {
        TextView view = new TextView(statField, charWidth);
        addComponent(colwidth, view);
        views.addElement(view);
        view.addDataChangeListener(this);
    }

    public void dataChanged(DataChangeEvent event)
    {
        FieldView view = (FieldView)event.getSource();
        String oldValue = event.getOldValue();
        String newValue = event.getNewValue();
        if(actor == null)
        {
            return;
        } else
        {
            modified = true;
            fireDataChangeEvent(event);
            return;
        }
    }

    public void fireDataChangeEvent(DataChangeEvent e)
    {
        mixin.fireDataChangeEvent(e);
    }

    public boolean isModified()
    {
        return modified;
    }

    private void newRow()
    {
        constraint.gridy++;
        constraint.gridx = 0;
    }

    public void removeDataChangeListener(DataChangeListener l)
    {
        mixin.removeDataChangeListener(l);
    }

    public void setActor(Actor actor, Mercenary merc)
    {
        this.actor = actor;
        this.merc = merc;
        Structure struct;
        if(this.merc != null)
        {
            struct = this.merc;
            struct.chain(this.actor);
        } else
        {
            struct = this.actor;
        }
        FieldView view;
        for(Enumeration e = views.elements(); e.hasMoreElements(); view.refresh())
        {
            view = (FieldView)e.nextElement();
            view.setStruct(struct);
        }

        modified = false;
    }

    public void setModified(boolean modified)
    {
        this.modified = modified;
    }

    private Frame parent;
    private GridBagLayout layout;
    private GridBagConstraints constraint;
    private boolean modified;
    private Actor actor;
    private Mercenary merc;
    private Vector views;
    private DataChangeMixin mixin;
}
